//
//  MCDialerDeviceProtocol.h
//  MCApplication
//
//  Created by DayLite1 on 06/09/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCAutoDialer;

@protocol MCDialerDevice <NSObject>

// called when the user selected another device, gives you a chance to clean up if needed
- (void)disengageDialerDeviceFromAutoDialer:(MCAutoDialer *)dialer;

// called as the user select your device, gives you a chance to prepare the device for usage
- (void)initializeDialerDeviceForAutoDialer:(MCAutoDialer *)dialer;

// return a unique identifier in the form of com.marketcircle.application.modem.dialer. You should return an identifier that is unique to your device
- (NSString *)deviceIdentifier;

// return a localized name. Used as the device name
- (NSString *)userPresentableName;

// return a view
- (NSView *)devicePreferenceViewForAutoDialer:(MCAutoDialer *)dialer;

- (NSFormatter *)dialerPhoneFieldFormatterForAutoDialer:(MCAutoDialer *)dialer;


- (NSString *)prepareNumberForDisplay:(NSString *)str inAutoDialer:(MCAutoDialer *)dialer;

- (BOOL)enableMCLocations;


- (NSError *)dialForAutoDialer:(MCAutoDialer *)dialer;

- (NSError *)hangupForAutoDialer:(MCAutoDialer *)dialer;



@end
